' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa AppConfiguration eksponuje publiczne wlaciwoci, ktre w zasadzie opakowuj wartoci zawarte w pliku Web.config.
''' </summary>
Public Class AppConfiguration

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Ukryj konstruktor aby unikn tworzenia instancji klasy AppConfiguration.
  ''' </summary>
  Private Sub New()
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Zwraca acuch poczenia dla aplikacji Baza Bdw.
  ''' </summary>
  Public Shared ReadOnly Property ConnectionString() As String
    Get
      Dim tempValue As String = "server=(local)\SqlExpress;AttachDbFileName=|DataDirectory|BugBase.mdf;Integrated Security=true;User Instance=true"
      Try
        If ConfigurationManager.ConnectionStrings("BugBase") IsNot Nothing Then
          tempValue = ConfigurationManager.ConnectionStrings("BugBase").ConnectionString
        End If
      Catch ex As Exception
        ' Jesli nie moemy pobra ustawienia z pliku konfiguracyjnego, ignorujemy bd i zwracamy
        ' domylny acuch poaczenia wskazujcy na instancj SqlExpress na lokalnym 
        ' komputerze i prbujemy poczy si z baz danych Bazy Bdw automatycznie.
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Zwraca nazw bazy danych uzywanej w aplikacji Baza Bdw.
  ''' </summary>
  Public Shared ReadOnly Property DatabaseName() As String
    Get
      Dim tempValue As String = "BugBase"
      Try
        If ConfigurationManager.AppSettings.Get("DatabaseName") IsNot Nothing Then
          tempValue = ConfigurationManager.AppSettings.Get("DatabaseName")
        End If
      Catch ex As Exception
        ' Jeli nie moemy pobra ustawienia z pliku konfiguracyjnego, ignorujemy bd i zwracamy domyln nazw bazy danych.
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Zwraca adres e-mail, na ktry wysyane s komunikaty o bdach.
  ''' </summary>
  Public Shared ReadOnly Property EmailToAddressForErrors() As String
    Get
      Dim tempValue As String = "Ty@TwojDostawcaInternetu.Pl"
      Try
        If ConfigurationManager.AppSettings.Get("EmailToAddressForErrors") IsNot Nothing Then
          tempValue = ConfigurationManager.AppSettings.Get("EmailToAddressForErrors")
        End If
      Catch ex As Exception
        ' Jeli nie moemy pobra ustawienia z pliku konfiguracyjnego, ignorujemy bd i zwracamy domylny adres e-mail.
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Zwraca adres e-mail, z ktrego wysyane s komunikaty o bdach.
  ''' </summary>
  Public Shared ReadOnly Property EmailFromAddressForErrors() As String
    Get
      Dim tempValue As String = "Ty@TwojDostawcaInternetu.Pl"
      Try
        If ConfigurationManager.AppSettings.Get("EmailFromAddressForErrors") IsNot Nothing Then
          tempValue = ConfigurationManager.AppSettings.Get("EmailFromAddressForErrors")
        End If
      Catch ex As Exception
        ' Jeli nie moemy pobra ustawienia z pliku konfiguracyjnego, ignorujemy bd i zwracamy domylny adres e-mail.
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Ustala, czy aplikacja wysya informacje o wyjtkach przez e-mail.
  ''' </summary>
  Public Shared ReadOnly Property SendMailOnErrors() As Boolean
    Get
      ' Wartoci domylna jest False. Jeli brakuje tego klucza, prawdopodobnie nie ma take wymaganych adresw e-mail.
      Dim tempValue As Boolean = False
      Try
        If ConfigurationManager.AppSettings.Get("SendMailOnErrors") IsNot Nothing Then
          tempValue = Convert.ToBoolean(ConfigurationManager.AppSettings.Get("SendMailOnErrors"))
        End If
      Catch ex As Exception
        ' Jeli nie moemy pobra ustawienia z pliku konfiguracyjnego, ignorujemy bd i zwracamy domyln warto False.
      End Try
      Return tempValue
    End Get
  End Property
#End Region

End Class